#ifndef __CComboBox__
#define __CComboBox__

#include "CTextLabel.hpp"
#include "CMenu.hpp"
#include "../Windowing/CMenuWindow.hpp"
#include "../Listeners/IMenuListener.hpp"

//	===========================================================================

using Exponent::GUI::Windowing::CMenuWindow;
using Exponent::GUI::Controls::CTextLabel;
using Exponent::GUI::Controls::CMenu;
using Exponent::GUI::Listeners::IMenuListener;

//	===========================================================================

namespace Exponent
{
	namespace GUI
	{
		namespace Controls
		{
			/**
			 * @class CComboBox CComboBox.hpp
			 * @brief Displays text in a box area on click opens up a popup menu
			 *
			 * @date 17/04/2005
			 * @author Paul Chana
			 * @version 1.0.0 Initial version
			 *
			 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
			 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
			 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
			 * All content is the Intellectual property of Exp Digital Uk.\n
			 * Certain sections of this code may come from other sources. They are credited where applicable.\n
			 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
			 *
			 * $Id: CComboBox.hpp,v 1.6 2007/02/08 21:07:54 paul Exp $
			 */
			class CComboBox : public CTextLabel, public IMenuListener
			{
				/** @cond */
				EXPONENT_CLASS_DECLARATION;
				/** @endcond */

//	===========================================================================
		
			public:

//	===========================================================================

				/**
				 * Construction
				 * @param root The root control that this control is being added to
				 * @param uniqueId The unique Identifier of this control or CCONTROL_NO_ID_REQUIRED if no id is required
				 * @param area The area of this control relative to the root controls top left
				 * @param text The default text to display
				 * @param menu The menu to display on click
				 * @param listener The action listener
				 */
				CComboBox(IControlRoot *root, const long uniqueId, const CRect &area, const CString &text, CMenu *menu, IActionListener *listener);

				/**
				 * Destruction
				 */
				virtual ~CComboBox();

//	===========================================================================

				/**
				 * Handle left button being clicked
				 * @param event The event to handle
				 */
				virtual void handleLeftButtonDown(CMouseEvent &event);

				/**
				 * Handle a menu selection
				 * @param event The event to handle
				 */
				virtual void handleMenuSelection(const CMenuEvent &event);

				/**
				 * Handle a menu opening
				 * @param event The event to handle
				 */
				virtual void handleMenuOpening(const CMenuEvent &event) {}

				/**
				 * Handle a menu closing
				 * @param event The event to handle
				 */
				virtual void handleMenuClosing(const CMenuEvent &event);

//	===========================================================================

				/**
				 * Draw the control
				 * @param graphics The graphics context
				 */
				virtual void drawControl(CGraphics &graphics);

				/**
				 * Set the menu
				 * @param menu The menu to display
				 */
				virtual void setMenu(CMenu *menu);

				/**
				 * Get the menu
				 * @retval CMenu* The menu
				 */
				CMenu *getMenu() { return m_menu; }

				/**
				 * Set the selected index
				 * @param index The index of the text to display from themeu in the text area
				 */
				virtual void setSelectedIndex(const long index);

				/**
				 * Get the menu item at an index
				 * @param index The index of the menu item required
				 * @retval CMenuItem* The item or null on error
				 */
				virtual CMenuItem *getMenuItem(const long index);

				/**
				 * Get the menu window
				 * @retval CMenuWindow* The menu window being used
				 */
				virtual CMenuWindow *getMenuWindow() { return m_menuWindow; }

				/**
				 * Get the selected index
				 * @retval long The index the user has selected from the menu
				 */
				virtual long getSelectedIndex() const { return m_selectedIndex; }

				/**
				 * Get the selected menu item
				 * @retval const CMenuItem* The last menu item recieved, may be NULL
				 */
				const CMenuItem *getLastMenuItem() const { return m_selectedItem; }

//	===========================================================================

				/**
				 * Set the text info
				 * @param font The font to display
				 */
				virtual void setFont(CFont *font);

				/**
				 * Set the window colours
				 * @param colours The menu colours to use
				 */
				virtual void setMenuColours(const SMenuColours &colours);

				/**
				 * Set the down image
				 * @param downImage The image to display when the menu is open
				 */
				virtual void setDownImage(IImage *downImage);

//	===========================================================================

				/**
				 * Set menu window attributes
				 * @param windowAttributes The attributes for the menu window
				 * @param useIcons If true icons are displayed for menu items, if false they are not
				 */
				virtual void setMenuWindowAttributes(CWindowAttributes *windowAttributes, const bool useIcons = true);

//	===========================================================================

			protected:

//	===========================================================================

				CMenu *m_menu;								/**< The menu */
				CMenuWindow *m_menuWindow;					/**< Popup menu window */
				CWindowAttributes *m_windowAttributes;		/**< Attributes of window */
				bool m_useIcons;							/**< Should menu use icons */
				long m_selectedIndex;						/**< Selected index of the combo box */
				bool m_state;								/**< Current state (true = down) */
				IImage *m_downImage;						/**< Image to use when down */
				CMenuItem *m_selectedItem;					/**< The currently selected menu item */
			};
		}
	}
}
#endif	// End of CComboBox.hpp